<?php
/* --------------------------------------------------------------
   WithdrawalService.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal;

use Gambio\Admin\Withdrawal\Interfaces\Withdrawal;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalId;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalIds;
use Gambio\Admin\Withdrawal\Interfaces\Withdrawals;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalSqlCriteria;
use Gambio\Admin\Withdrawal\Interfaces\WithdrawalSqlPagination;
use Gambio\Admin\Withdrawal\Repository\WithdrawalRepository;

/**
 * Class WithdrawalService
 *
 * @package Gambio\Admin\Withdrawal
 */
class WithdrawalService implements Interfaces\WithdrawalService
{
    /**
     * @var WithdrawalRepository
     */
    private $repository;
    
    
    public function __construct(WithdrawalRepository $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getAllWithdrawals(
        WithdrawalSqlCriteria $criteria,
        WithdrawalSqlPagination $pagination
    ): Withdrawals {
        return $this->repository->getAll($criteria, $pagination);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getTotalCountOfWithdrawals(WithdrawalSqlCriteria $criteria): int
    {
        return $this->repository->getTotalCount($criteria);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getWithdrawalById(WithdrawalId $id): Withdrawal
    {
        return $this->repository->getById($id);
    }
    
    
    /**
     * @inheritDoc
     */
    public function storeWithdrawal(Withdrawal $Withdrawal): WithdrawalId
    {
        return $this->repository->store($Withdrawal);
    }
    
    
    /**
     * @inheritDoc
     */
    public function storeWithdrawals(Withdrawals $Withdrawals): WithdrawalIds
    {
        return $this->repository->storeMultiple($Withdrawals);
    }
    
    
    /**
     * @inheritDoc
     */
    public function deleteWithdrawal(WithdrawalId $id): void
    {
        $this->repository->delete($id);
    }
    
    
    /**
     * @inheritDoc
     */
    public function deleteWithdrawals(WithdrawalIds $ids): void
    {
        $this->repository->deleteMultiple($ids);
    }
}